// AP2VIEW.CPP
//

#include <coemain.h>

#include "ap2view.h"
#include "ap2view.inc"

/*
	CAppleIIView
*/

const TInt XSIZE = 280;
const TInt YSIZE = 192;

CAppleIIView::CAppleIIView(const CCoeControl* aParent, const TRect& aRect, TAppleII* aModel)
	: iModel(aModel), iParent(aParent), iOfferedRect(aRect)
	{
	lastgrmode = -1;
	}

/*
CAppleIIView::CAppleIIView()
	{ // private, so never gets invoked; required for DLL goodness reasons
	}
*/

void CAppleIIView::ConstructL()
	{
	// create window
	CreateWindowL(iParent);
	// make lookup table
	colors_lut = new (ELeave) TAppleHiresLUT();
	// construct bitmap
	iBitmap = new (ELeave) CFbsBitmap();
	User::LeaveIfError(iBitmap->Create(TSize(XSIZE, YSIZE), EGray4));
	// set rectangle to prescription
	SetRectL(iOfferedRect);
	// go for it
	ActivateL();
	}

CAppleIIView::~CAppleIIView()
	{
	if (colors_lut)
		delete colors_lut;
	if (iBitmap)
		delete iBitmap;
	}

#define PIXELON 0xffffff
#define PIXELOFF 0

void CAppleIIView::RenderTextLine(TInt y, const TCharRow charrow)
{
	TBitmapUtil* bmputil = new (ELeave) TBitmapUtil(iBitmap);
	bmputil->Begin(TPoint(0,0));

	// see if we have 4 grays, if so, do it the fast way
	TDisplayMode dm = iBitmap->DisplayMode();
	if (dm == EGray4)
	{
		TUint32* addr = iBitmap->DataAddress();
		TInt scanlen = CFbsBitmap::ScanLineLength(iBitmap->SizeInPixels().iWidth, dm);

		for (TInt yy=0; yy<8; yy++)
		{
			TInt base = (scanlen/4)*(y*8+yy);
			TUint32 curword = 0;
			TUint32 mask = 3;
			for (TInt xx=0; xx<40; xx++)
			{
				TInt b = charrow[xx];
				TInt texel = (TInt) texels[b & 0x7f][yy];
				if ((b & 0x80) != 0) 
				{
					texel = ~texel;
				}
				for (TInt xpix=0; xpix<7; xpix++)
				{
					if ((texel & (2<<xpix)) > 0)
					{
						curword |= mask;
					}
					mask <<= 2;
					if (!mask)
					{
						addr[base++] = curword;
						curword = 0;
						mask = 3;
					}
				}
			}
			if (mask != 3)
			{
				addr[base++] = curword;
			}
		}

	} else {

		TInt ystart=y*8;
		TInt xx, yy;
		for (yy=0; yy<8; yy++)
		{
			bmputil->SetPos(TPoint(0, ystart+yy));
			for (xx=0; xx<40; xx++)
			{
				TInt b = charrow[xx];
				TInt texel = (TInt) texels[b&0x7f][yy];
				if (b&0x80 != 0) 
					texel = ~texel;
				for (TInt xpix=0; xpix<7; xpix++)
				{
					TInt color = ((texel & (2<<xpix)) > 0) ? PIXELON : PIXELOFF;
					bmputil->SetPixel(color);
					bmputil->IncXPos();
				}
			}
		}

	}

	bmputil->End();
	delete bmputil;
}

void CAppleIIView::RenderLoresLine(TInt y, const TCharRow charrow)
{
	TBitmapUtil* bmputil = new (ELeave) TBitmapUtil(iBitmap);
	bmputil->Begin(TPoint(0,0));

	{

		TInt ystart=y*8;
		TInt xx, yy;
		for (yy=0; yy<8; yy++)
		{
			bmputil->SetPos(TPoint(0, ystart+yy));
			for (xx=0; xx<40; xx++)
			{
				TInt b = charrow[xx];
				TUint32 color = loresColor[(yy < 4) ? b & 0xf : b >> 4];
				for (TInt xpix=0; xpix<7; xpix++)
				{
					bmputil->SetPixel(color);
					bmputil->IncXPos();
				}
			}
		}

	}

	bmputil->End();
	delete bmputil;
}

	TInt CAppleIIView::DrawTextLine(TInt y, TBool flash)
	{
		// get the base address of this line
		TInt base = text_lut[y] +
			(((iModel->getGrswitch() & GR_PAGE1) != 0) ? 0x800 : 0x400);
		if (flash == lastflash && !iModel->isDirty(base))
		    return 0;
		TCharRow charrow;
		TBool drewFlashChar = false;
		for (TInt x=0; x<40; x++)
		{
			TInt b = iModel->getMemory()[base+x];
			TBool invert;
			// invert flash characters 1/2 of the time
			if (b >= 0x80) {
			    invert = false;
			}
			else if (b >= 0x40) {
			    invert = flash;
			    if (flash)
			        b -= 0x40;
			    else
			        b += 0x40;
				drewFlashChar = true;
			}
			else
			    invert = true;
			charrow[x] = (unsigned char)((b & 0x7f) | (invert ? 0x80 : 0x00));
			// if the char. changed, draw it
			//DrawTextChar(x, y, b & 0x7f, invert);
		}
		if (!drewFlashChar && !iModel->isDirty(base))
		    return 0;
		// now actually render the line
		RenderTextLine(y, charrow);
		return 8;
	}

	TInt CAppleIIView::DrawLoresLine(TInt y)
	{
		// get the base address of this line
		TInt base = text_lut[y] +
			(((iModel->getGrswitch() & GR_PAGE1) != 0) ? 0x800 : 0x400);
		if (!iModel->isDirty(base))
		    return 0;
		TCharRow charrow;
		for (TInt x=0; x<40; x++)
		{
			TInt b = iModel->getMemory()[base+x];
			charrow[x] = (unsigned char)b;
		}
		// now actually render the line
		RenderLoresLine(y, charrow);
		return 8;
	}

#define FLUSHPIXEL addr[gbase] = curword;

#define PUTPIXEL(color) \
	curword |= (color << shift); \
	shift += 2; \
	if (shift == 32) { FLUSHPIXEL gbase++; curword = shift = 0; }


	TInt CAppleIIView::DrawHiresLines(TInt y, TInt maxy)
	{
		TBitmapUtil* bmputil = new (ELeave) TBitmapUtil(iBitmap);
		bmputil->Begin(TPoint(0,0));
		TInt total = 0;

		// see if we have 4 grays, if so, do it the fast way
		TDisplayMode dm = iBitmap->DisplayMode();
		if (dm == EGray4)
		{
			TUint32* addr = iBitmap->DataAddress();
			TInt scanlen = CFbsBitmap::ScanLineLength(iBitmap->SizeInPixels().iWidth, dm);

			byte* mem = iModel->getMemory();
			for (; y < maxy; y++)
			{
	    		TInt base = hires_lut[y] +
    				(((iModel->getGrswitch() & GR_PAGE1) != 0) ? 0x4000 : 0x2000);
				if (!iModel->isDirty(base))
					continue;
				TInt b = 0;
				TInt b1 = mem[base];
				TInt gbase = (scanlen/4)*(y);
				TUint32 curword = 0;
				TUint32 shift = 0;

    			for (TInt x1=0; x1<20; x1++)
    			{
	    		    TInt b2 = mem[base+1];
    				TInt b3 = mem[base+2];
					TInt xx,d;
               		d = (((b&0x40)<<2) | b1 | b2<<9) & 0x3ff;
					d = d*7;
					for (xx=0; xx<7; xx++) {
						TInt color = (*colors_lut)[d+xx];
						PUTPIXEL(color);
					}
               		d = (((b1&0x40)<<2) | b2 | b3<<9) & 0x3ff;
					d = d*7+7168;
					for (xx=0; xx<7; xx++) {
						TInt color = (*colors_lut)[d+xx];
						PUTPIXEL(color);
					}
               		base += 2;
               		b = b2;
               		b1 = b3;
				}
				FLUSHPIXEL
				total++;
			}

		} else {
			// the slow way

			byte* mem = iModel->getMemory();
			for (; y < maxy; y++)
			{
	    		TInt base = hires_lut[y] +
    				(((iModel->getGrswitch() & GR_PAGE1) != 0) ? 0x4000 : 0x2000);
				if (!iModel->isDirty(base))
					continue;
					TInt b = 0;
				TInt b1 = mem[base];
				bmputil->SetPos(TPoint(0, y));
    			for (TInt x1=0; x1<20; x1++)
    			{
	    		    TInt b2 = mem[base+1];
    				TInt b3 = mem[base+2];
               		TInt d1 = (((b&0x40)<<2) | b1 | b2<<9) & 0x3ff;
					TInt xx;
					for (xx=0; xx<7; xx++) {
						TInt color = (*colors_lut)[d1*7+xx];
						bmputil->SetPixel(color);
						bmputil->IncXPos();
					}
               		//System.arraycopy(colors_lut, (d1*7), pixels, yb, 7);
               		TInt d2 = (((b1&0x40)<<2) | b2 | b3<<9) & 0x3ff;
					for (xx=0; xx<7; xx++) {
						TInt color = (*colors_lut)[d2*7+7168+xx];
						bmputil->SetPixel(color);
						bmputil->IncXPos();
					}
               		//System.arraycopy(colors_lut, (d2*7)+7168, pixels, yb+7, 7);
               		//yb += 14;
               		base += 2;
               		b = b2;
               		b1 = b3;
				}
				total++;
			}
		}

		bmputil->End();
		delete bmputil;
		return total;
	}

// flash twice every second
const TInt flashInterval = 1000000;

TInt CAppleIIView::Render()
{
		TInt y;
		TInt total = 0;
		TBool flash = (iModel->getState()->getClock() % (flashInterval<<1)) > flashInterval;

		// see if gr mode changed
		if (iModel->getGrswitch() != lastgrmode)
		{
			iModel->setRangeDirty(0, 0xffff, true);
			lastgrmode = iModel->getGrswitch();
		}

		// first, draw top part of window
		if ((iModel->getGrswitch() & GR_TXMODE) != 0) {
			for (y=0; y<20; y++)
				total += DrawTextLine(y, flash);
		} else {
			if ((iModel->getGrswitch() & GR_HIRES) != 0)
		        total += DrawHiresLines(0, 160);
			else
				for (y=0; y<20; y++)
					total += DrawLoresLine(y);
		}

		// now do mixed part of window
		if ((iModel->getGrswitch() & GR_TXMODE) != 0 || (iModel->getGrswitch() & GR_MIXMODE) != 0)
		{
			for (y=20; y<24; y++)
				total += DrawTextLine(y, flash);
		} else {
			if ((iModel->getGrswitch() & GR_HIRES) != 0)
		        total += DrawHiresLines(160, 192);
			else
				for (y=20; y<24; y++)
					total += DrawLoresLine(y);
		}

		// set all pages clean again
		iModel->setRangeDirty(0, 0xffff, false);
		lastflash = flash;

		return total;
}

void CAppleIIView::Draw(const TRect& /*aRect*/) const
	{
	CWindowGc& gc=SystemGc();
	TPoint pos = TPoint(0,0);
	gc.BitBlt(pos, iBitmap);
	}

